//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "HighLightUtils.h"
#include "Unit2.h"
//---------------------------------------------------------------------------
bool __fastcall MustBeColored(const String aKey, const TStringList* KeyList)
{
  int I; int C;
  int L = 0;
  int H = KeyList->Count-1;
  while( L <= H )
  {
    I = ((L + H) >> 1);
    C = CompareText(KeyList->Strings[I],aKey);
    if (C < 0)  L = I + 1;
    else
    {
      H = I - 1;
      if (C == 0) return true;
    }
  }
  return false;
}

String __fastcall GetWord(int pos)
{
  TTextRangeA TR;

  long strt  = Form2->CurrentRichEdit()->Perform(EM_FINDWORDBREAK, WB_MOVEWORDLEFT,pos);
  long ln   = Form2->CurrentRichEdit()->Perform(EM_FINDWORDBREAK, WB_RIGHTBREAK, pos) - strt-1;
  TR.chrg.cpMin = strt;
  TR.chrg.cpMax = strt+ln;

  TR.lpstrText = (char *) malloc(ln+1);
  Form2->CurrentRichEdit()->Perform(EM_GETTEXTRANGE, 0,long(&TR.chrg));
  AnsiString result = TR.lpstrText;
  free(TR.lpstrText);

  return result ;
}


void __fastcall CheckCurrentPosition()
{
if (!(Form2->CurrentRichEdit()->SelAttributes->Color == DefaultCommentColor))
{
  long CurrPos = Form2->CurrentRichEdit()->SelStart;
  String KeyW = GetWord(CurrPos);
  KeyW.Trim();
  long Len = KeyW.Length();
  long Start = CurrPos - Len;

  if (MustBeColored(KeyW, Form2->FSpecial))
  {
    ReplaceKeyword(Start, Start+Len, KeyW, fsBold, clBlue);
  }
  else if (MustBeColored(KeyW, Form2->FRegisters))
  {
    ReplaceKeyword(Start, Start+Len, KeyW, fsBold, (TColor)DefaultRegisterColor);
  }
  else if (MustBeColored(KeyW, Form2->FDirectives))
  {
    ReplaceKeyword(Start, Start+Len, KeyW, fsBold, (TColor)DefaultDirectiveColor);
  }
  else if (MustBeColored(KeyW, Form2->FOpCodes))
  {
    ReplaceKeyword(Start, Start+Len, KeyW, fsBold, (TColor)DefaultOpcodeColor);
  }
}
}


void __fastcall RecheckCurrentPosition()
{
if (!(Form2->CurrentRichEdit()->SelAttributes->Color == DefaultCommentColor))
{
  long CurrPos = Form2->CurrentRichEdit()->SelStart;
  String KeyW = GetWord(CurrPos);
  long Len = KeyW.Length();
  long Start = CurrPos - Len;

  if (Form2->CurrentRichEdit()->SelAttributes->Style.Contains((TFontStyle)DefaultHighLightStyle))
  {
  	if (MustBeColored(KeyW, Form2->FSpecial))
    {
      ReplaceKeyword(Start, Start+Len, KeyW, fsBold, clBlue);
    }
	else if (MustBeColored(KeyW, Form2->FRegisters))
    {
      ReplaceKeyword(Start, Start+Len, KeyW, fsBold, (TColor)DefaultRegisterColor);
    }
    else if (MustBeColored(KeyW, Form2->FDirectives))
    {
      ReplaceKeyword(Start, Start+Len, KeyW, fsBold, (TColor)DefaultDirectiveColor);
    }
    else if (MustBeColored(KeyW, Form2->FOpCodes))
    {
      ReplaceKeyword(Start, Start+Len, KeyW, fsBold, (TColor)DefaultOpcodeColor);
    }
    else
    {
      ClrKeyword(Start, Start+Len, KeyW);
    }
  }
  Form2->CurrentRichEdit()->SelStart = CurrPos;
}
}

void __fastcall InitializeKeywords()
{
  Form2->FOpCodes = new TStringList() ;
  Form2->FOpCodes->Sorted = true;
  for (int i = 0; i<NUMOPCODES ; i++) Form2->FOpCodes->Add(_Opcodes[i]);

  Form2->FRegisters = new TStringList();
  Form2->FRegisters->Sorted = true;
  for (int i=0; i<NUMREGISTERS; i++) Form2->FRegisters->Add(_Registers[i]);

  Form2->FDirectives = new TStringList();
  Form2->FDirectives->Sorted = true;
  for (int i=0; i<NUMDIRECTIVES; i++) Form2->FDirectives->Add(_Directives[i]);

  Form2->FSpecial = new TStringList();
  Form2->FSpecial->Sorted = true;
  for (int i=0; i<NUMSPECIALS; i++) Form2->FSpecial->Add(_Special[i]);
}



void __fastcall DeInitKeywords()
{
  Form2->FOpCodes->Free();
  Form2->FRegisters->Free();
  Form2->FDirectives->Free();
  Form2->FSpecial->Free();
}










void __fastcall ReplaceKeyword (long FirstChar, long LastChar,  String S, TFontStyle FontSt, TColor Color)
{
  TCharRange Selection;
  Selection.cpMin = FirstChar;
  Selection.cpMax = LastChar;
  TFontStyles  FontStyle;


  Form2->CurrentRichEdit()->Perform(EM_HIDESELECTION, 1,0);
  Form2->CurrentRichEdit()->Perform(EM_EXSETSEL, 0, long(&Selection));
  FontStyle<< FontSt;
  Form2->CurrentRichEdit()->SelAttributes->Style = FontStyle;
  Form2->CurrentRichEdit()->SelAttributes->Color = Color;
//  CurrentRichEdit()->Perform(EM_REPLACESEL, 0, long(&S[1]));
  Form2->CurrentRichEdit()->SelStart = LastChar;
  Form2->CurrentRichEdit()->SelLength = 0;
  Form2->CurrentRichEdit()->Perform(EM_HIDESELECTION, 0,0);

  FontStyle.Clear();
  Form2->CurrentRichEdit()->SelAttributes->Style = FontStyle;
  Form2->CurrentRichEdit()->SelAttributes->Color = (TColor)DefaultTextColor;
}




void __fastcall ClrKeyword (long FirstChar, long LastChar,  String S)
{
  TCharRange Selection;
  Selection.cpMin = FirstChar;
  Selection.cpMax = LastChar;
  TFontStyles FontStyle;

  FontStyle.Clear();

  Form2->CurrentRichEdit()->Perform(EM_HIDESELECTION, 1,0);
  Form2->CurrentRichEdit()->Perform(EM_EXSETSEL, 0, long(&Selection));
  Form2->CurrentRichEdit()->SelAttributes->Style = FontStyle;
  Form2->CurrentRichEdit()->SelAttributes->Color = (TColor)DefaultTextColor;
  Form2->CurrentRichEdit()->Perform(EM_REPLACESEL, 0, long(&S[1]));
  Form2->CurrentRichEdit()->Perform(EM_HIDESELECTION, 0,0);

}

void __fastcall ColorFromPos(int Pos, TColor Color)
{
  TCharRange Selection;
  TFontStyles FontStyle;

  FontStyle.Clear();
  FontStyle<<fsBold;

  int LineFrCh = Form2->CurrentRichEdit()->Perform(EM_LINEFROMCHAR, Pos, 0);
  int LineInd  = Form2->CurrentRichEdit()->Perform(EM_LINEINDEX, LineFrCh, 0);
  Selection.cpMin = Pos;
  Selection.cpMax = LineInd + Form2->CurrentRichEdit()->Perform(EM_LINELENGTH, Selection.cpMin, 0) ;


  Form2->CurrentRichEdit()->Perform(EM_HIDESELECTION, 1,0);
  Form2->CurrentRichEdit()->Perform(EM_EXSETSEL, 0, Longint(&Selection));
  Form2->CurrentRichEdit()->SelAttributes->Color = Color;
  Form2->CurrentRichEdit()->SelAttributes->Style = FontStyle;
  Form2->CurrentRichEdit()->SelLength = 0;
  Form2->CurrentRichEdit()->SelAttributes->Color = Color;
  Form2->CurrentRichEdit()->SelAttributes->Style = FontStyle;

  Form2->CurrentRichEdit()->Perform(EM_HIDESELECTION, 0,0);

}




void __fastcall ColorLine(int LineNum)
{

  Form2->CurrentRichEdit()->SelStart = Form2->CurrentRichEdit()->Perform(EM_LINEINDEX, LineNum, 0);
  long LineLength = Form2->CurrentRichEdit()->Perform(EM_LINELENGTH, Form2->CurrentRichEdit()->SelStart, 0);
  long MaxCharPos = LineLength + Form2->CurrentRichEdit()->SelStart;


  int prevpos = Form2->CurrentRichEdit()->SelStart -1 ;

  while (prevpos < Form2->CurrentRichEdit()->SelStart )
  {
    prevpos = Form2->CurrentRichEdit()->SelStart;

    TTextRangeA TR;
    long Start = Form2->CurrentRichEdit()->Perform(EM_FINDWORDBREAK, WB_MOVEWORDLEFT,prevpos+1) ;
    long Len   = Form2->CurrentRichEdit()->Perform(EM_FINDWORDBREAK, WB_RIGHTBREAK,prevpos)- Start;
    TR.chrg.cpMin = Start;
    TR.chrg.cpMax = Start+Len;
    if (TR.chrg.cpMax > MaxCharPos)
    {
      TR.chrg.cpMax = MaxCharPos;
      Len = MaxCharPos - Start;
    }

    TR.lpstrText = (char *) malloc(Len+1);
    Form2->CurrentRichEdit()->Perform(EM_GETTEXTRANGE, 0,long(&TR.chrg));
    AnsiString KeyW = TR.lpstrText;
    free(TR.lpstrText);

    KeyW.Trim();
    if (KeyW == "") break;

    Form2->CurrentRichEdit()->SelStart = Start;
    Form2->CurrentRichEdit()->SelLength = Len;

    Char FirstChar = KeyW[1];
    if (FirstChar == ';')
    {
      ColorFromPos(Start, (TColor) DefaultCommentColor);
      break;
    }
    else 

    if (MustBeColored(KeyW, Form2->FSpecial))
    {
      ReplaceKeyword(Start, Start+Len, KeyW, fsBold, clBlue);
    }
    else if (MustBeColored(KeyW, Form2->FRegisters))
    {
      ReplaceKeyword(Start, Start+Len, KeyW, fsBold, (TColor)DefaultRegisterColor);
    }
    else if (MustBeColored(KeyW, Form2->FDirectives))
    {
     ReplaceKeyword(Start, Start+Len, KeyW, fsBold, (TColor)DefaultDirectiveColor);
    }
    else if (MustBeColored(KeyW, Form2->FOpCodes))
    {
      ReplaceKeyword(Start, Start+Len, KeyW, fsBold, (TColor)DefaultOpcodeColor);
    }
    Form2->CurrentRichEdit()->SelLength = 0;
    Form2->CurrentRichEdit()->SelStart =Form2->CurrentRichEdit()->Perform(EM_FINDWORDBREAK, WB_MOVEWORDRIGHT,Start);
    if (Form2->CurrentRichEdit()->SelStart > MaxCharPos) break;

  }
}





